// Plik konfiguracyjny Karma, więcej informacji na jego temat znajdziesz na stronie 
// https://karma-runner.github.io/0.13/config/configuration-file.html.

module.exports = function (config) {
    config.set({
        basePath: '.',
        frameworks: ['jasmine'],
        files: [
            '../../wwwroot/dist/vendor.js',
            './boot-tests.ts'
        ],
        preprocessors: {
            './boot-tests.ts': ['webpack']
        },
        reporters: ['progress'],
        port: 9876,
        colors: true,
        logLevel: config.LOG_INFO,
        autoWatch: true,
        browsers: ['Chrome'],
        mime: { 'application/javascript': ['ts','tsx'] },
        singleRun: false,
        webpack: require('../../webpack.config.js')().filter(config => config.target !== 'node'), // Przetestowanie względem pakietu klienta, ponieważ testy są wykonywane w przeglądarce WWW.
        webpackMiddleware: { stats: 'errors-only' }
    });
};
